<div class="wrapper wrapper-content animated fadeInRight">

    <form class="form">
        <div class="form-group col-md-4">
            <input type="number" class="form-control" name="q" value="<?= $this->input->get_post('q') ?>" placeholder="Filter by Mobile Number">
        </div>
        <button type="submit" class="btn btn-info">Search</button>
    </form>
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">

            <?php if ($this->input->get_post('msg') == "success") { ?>
                <div class="col-md-12">
                    <div class="alert alert-success">
                        <strong>Success!</strong> Request completed successfully
                    </div>
                </div>
            <?php } ?>


            <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Withdraw Requests</h5>
                    </div>
                    <div class="ibox-content">
                        <table class="table table-bordered">
                            <tr>
                                <th>Name: <?php echo $user->name ?></th>
                                <th>Mobile: <?php echo $user->mobile ?></th>
                                <th>Role: <?php echo $this->roles_model->get_role_name_by_id($user->role_id) ?></th>
                            </tr>
                        </table>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Request ID</th>
                                    <th>Details</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Remark</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                foreach ($payments_ledger as $item) {
                                    ?>
                                    <tr>
                                        <td><?= $i++ ?></td>
                                        <td><?= $item->request_id ?></td>
                                        <td>
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <th>Role</th>
                                                        <td><?= $this->roles_model->get_role_name_by_id($item->bank_details->role_id) ?></td>
                                                    </tr>
                                                    <tr>
                                                        <th>Mobile</th>
                                                        <td><?= $item->bank_details->mobile ?></td>
                                                    </tr>
                                                    <tr>
                                                        <th>Account Name :</th>
                                                        <td><?= $item->bank_details->account_name ?></td>
                                                    </tr>
                                                    <tr>
                                                        <th>Account Number : </th>
                                                        <td> <?= $item->bank_details->account_number ?></td>
                                                    </tr>
                                                    <tr>
                                                        <th>Bank Name :</th>
                                                        <td><?= $item->bank_details->bank_name ?></td>
                                                    </tr>
                                                    <tr>
                                                        <th>Branch Name :</th>
                                                        <td><?= $item->bank_details->branch ?></td>
                                                    </tr>
                                                    <tr>
                                                        <th>IFSC :</th>
                                                        <td> <?= $item->bank_details->ifsc_code ?></td>
                                                    </tr>
                                                    <tr>
                                                        <th>Request Date :</th>
                                                        <td> <?= date("d-m-Y", $item->created_at) ?></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                        <td><?= $item->action_type ?></td>
                                        <td><span class="amount"><?= $item->amount ?></span></td>
                                        <td><?= $item->remark ?></td>
                                        <td><?= $item->request_status ?></td>
                                        <td>
                                            <?php if ($item->request_status == "Pending") { ?>
                                                <button class="btn btn-success btn-xs approveBtn" data-user-id="<?//= $item->id ?>" value="<?= $item->id ?>">Approve</button>
                                            <?php } else { ?>
                                                <?= $item->request_status ?>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Update Wallet Add (or) WithDraw Amount</h4>
                </div>
                <div class="modal-body">
                    <form method="post">
                        <input type="hidden" name="id" id="id"/>
                        <div class="form-group">
                            <label for="amount">Amount:</label>
                            <input type="number" min="1" max="99999" class="form-control" name="amount" id="amount" required readonly>
                        </div>
                        <div class="form-group">
                            <label for="action_type">For:</label>
                            <input type="text" name="action_type" class="form-control" value="Debit" readonly required/>
                        </div>
                        <div class="form-group">
                            <label for="transaction_ref_id">Transaction Ref ID:</label>
                            <input type="text" class="form-control" name="transaction_ref_id" id="transaction_ref_id" required>
                        </div>
                        <div class="form-group">
                            <label for="transaction_ref_id">Remarks:</label>
                            <textarea class="form-control" name="remark" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-success">Update Wallet</button>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>

        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $(document).on('click', ".approveBtn", function () {
            $("#myModal").modal("show");
            $("#id").val($(this).val());
            $("#amount").val($(this).closest("tr").find(".amount").html());
            //$("#transaction_ref_id").val($(this).closest("tr").find(".ref_no").html());
            //location.href = "<?= base_url() ?>admin/payments_ledger/approve?q=<?= $this->input->get_post('q') ?>&id=<?= $item->id ?>";
        });
    });
</script>