<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h4 class="myhead">Service Summary
                        <b class="pull-right">#<?= $item->booking_id ?></b>
                    </h4>
                </div>
                <div class="ibox-content">
                    <div class="row r-m-05">
                        <div class="col-md-12 c-p-05">
                            <div class="panel panel-default m-b-1">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Billing Details</h3>
                                </div>
                                <div class="panel-body">
                                    <b><?= $item->customer_name ?></b>
                                    <pre><?= $item->customer_address . '<br>Pincode: ' . $item->customer_pincode ?><br/>Phone:<?= $item->user_details->mobile ?></pre>

                                </div>
                            </div>
                        </div>
                    </div>
                    <table class="table order_table m-a-0 m-b-1">
                        <thead>
                            <tr>
                                <th>Service Date</th>
                                <th>Service Title</th>
                                <th>Service Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?= date('d-m-Y h:i a', $item->created_at) ?></td>
                                <td><b><?= $item->sub_category_name ?>/<?= $item->service_subject ?></b></td>
                                <?php
                                if ($item->service_status == 'Pending') {
                                    $bootstrap_class = 'warning';
                                } elseif ($item->service_status == 'Accepted') {
                                    $bootstrap_class = 'success';
                                } elseif ($item->service_status == 'Cancelled') {
                                    $bootstrap_class = 'danger';
                                } elseif ($item->service_status == 'Completed') {
                                    $bootstrap_class = 'primary';
                                } elseif ($item->service_status == 'Rejected') {
                                    $bootstrap_class = 'danger';
                                } elseif ($item->service_status == 'Process') {
                                    $bootstrap_class = 'success';
                                }
                                ?>
                                <td><span class="label label-<?= $bootstrap_class ?>"><?= $item->service_status ?></span></td>
                            </tr>
                        </tbody>
                    </table> 
                    <div class="row r-m-05" ng-show="order_view.message != ''">
                        <div class="col-md-12 c-p-05">
                            <div class="panel panel-default m-b-1">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Customer Message</h3>
                                </div>
                                <div class="panel-body">
                                    <pre><?= $item->message ?></pre>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row r-m-05" ng-if="order_view.log_history">
                        <div class="col-md-12 c-p-05">
                            <div class="panel panel-default m-b-1">
                                <div class="panel-heading">
                                    <h3 class="panel-title">Process Log</h3>
                                </div>
                                <div class="panel-body">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date Time</th>
                                                <th>Person Name</th>
                                                <th>Role</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            foreach ($process_log as $plitem) {
                                                ?>
                                                <tr>
                                                    <td><?= $plitem->action_type ?></td>
                                                    <td><?= date('d-m-Y h:i a', $plitem->action_triggered_at) ?></td>
                                                    <td><?= $plitem->person_name ?></td>
                                                    <td><?= $plitem->role_name ?></td>
                                                </tr>
                                                <?php
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="panel panel-default m-b-1" ng-show="order_view.service_status === 'Completed' && order_view.payment_status === 'Paid' && order_view.is_customer_accepted == 1">
                        <div class="panel-heading text-center">
                            <h3 class="panel-title">Summary</h3>
                        </div>
                        <div class="panel-body text-center">
                            <pre style="text-align: left;"><?= $item->remark ?></pre>

                            <table class="table-bordered table table-responsive table-hover">
                                <tr>
                                    <th>Sub Total</th>
                                    <td class="text-right">Rs.   <?= number_format($item->payable_amount, 2) ?></td>
                                </tr>
                                <tr>
                                    <th>Service Charge (<?= $item->markup_value ?> <?= $item->markup_type ?>)</th>
                                    <td class="text-right">Rs.   <?= number_format($item->service_charge, 2) ?> </td>
                                </tr>
                                <tr>
                                    <th>Grand Total</th>
                                    <td class="text-right"><b>Rs.  <?= number_format($item->grand_total, 2) ?></b>   </td>
                                </tr>

                                <tr>
                                    <th>Admin Share</th>
                                    <td class="text-right"><b>Rs.  <?= number_format($item->admin_share_amount, 2) ?></b>   </td>
                                </tr>
                                <tr>
                                    <th>Franchise Share</th>
                                    <td class="text-right"><b>Rs.  <?= number_format($item->franchise_share_amount, 2) ?></b>   </td>
                                </tr>
                                <tr>
                                    <th>Referral Share</th>
                                    <td class="text-right"><b>Rs.  <?= number_format($item->referral_share_amount, 2) ?></b>   </td>
                                </tr>
                                <tr>
                                    <th>Vendor Share</th>
                                    <td class="text-right"><b>Rs.  <?= number_format($item->vendor_earned_amount, 2) ?></b>   </td>
                                </tr>

                                <?php if ($item->apply_mark_up_calculation == 0) { ?>
                                    <tr>
                                        <th>Finally Vendor Earned Amount is : </th>
                                        <td class="text-right"><b>Rs.  <?= number_format($item->vendor_earned_amount, 2) ?></b>   </td>
                                    </tr>
                                <?php } ?>

                            </table>
                        </div>
                        <div class="panel-footer">
                            <p><span style="color:red">Note:</span> Admin Share = Admin Share - Referral Share</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>