<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Staff Attendance Report For the Month (<?=$this->input->get_post('month')?>-<?=$this->input->get_post('year')?>)</h5>
                </div>
                <div class="ibox-content">
					<form class="form">
					
						<div class="form-group col-md-3">
							<select required class="form-control" name="region_id">
								<option disabled selected>Select Region</option>
								<?php foreach($regions as $region){?>
								<option value="<?=$region->id?>" <?php if($region->id == $this->input->get_post('region_id')){
									echo "selected";
								}?>><?=$region->name?></option>
								<?php }?>
							</select>
						</div>
						
						<div class="form-group col-md-3">
							<select required class="form-control" name="store_id">
								<option disabled selected>Select Store</option>
								<?php foreach($stores as $store){?>
								<option value="<?=$store->id?>" <?php if($store->id == $this->input->get_post('store_id')){
									echo "selected";
								}?>><?=$store->store_name?></option>
								<?php }?>
							</select>
						</div>
						  
						  <div class="form-group col-md-3">
							<select required class="form-control" name="month">
								<option disabled selected>Select Month</option>
								<?php foreach($months as $month){?>
								<option value="<?=$month?>" <?php if($month == $this->input->get_post('month')){
									echo "selected";
								}?>><?=$month?></option>
								<?php }?>
							</select>
						  </div>
						  <div class="form-group col-md-2">
							<select required class="form-control" name="year">
								<option disabled selected>Select Year</option>
								<?php foreach($years as $year){?>
								<option value="<?=$year?>" <?php if($year == $this->input->get_post('year')){
									echo "selected";
								}?>><?=$year?></option>
								<?php }?>
							</select>
						  </div>
						  <button type="submit" class="btn btn-info">Submit</button>
					</form>
					<hr/>
						<div class="table-responsive">
						
							
							<table class="table table-striped table-bordered table-hover dataTables-example">
								<thead>
									<tr>
										<th style="width:2%">S.No</th>
										<th>Store Name</th>
										<th>Staff</th>
										<th>Employee Code</th>
										<th>Days Present</th>
										<?php foreach($this->data["headding_columns"] as $heading){?>
											<th style="white-space:nowrap"><?=$heading?></th>
										<?php }?>
									</tr>
								</thead>
								<tbody>
									<?php $i=0;
									foreach($staff as $s){
										$i++;?>
										<tr style="height:50px">
											<td><?=$i?></td>
											<td><?=$s->store_name?></td>
											<td><?=$s->name?></td>
											<td><?=$s->employee_id?></td>
											<td><?=isset($s->number_of_days_present) ? $s->number_of_days_present : 0?></td>
											
											<?php foreach($this->data["headding_columns"] as $heading){?>
											<td style="white-space:nowrap">
												<?=isset($s->$heading->check_in->time) ?$s->$heading->check_in->time : "--" ?>
												<br/>
												<?=isset($s->$heading->check_out->time) ? $s->$heading->check_out->time : '--' ?>
											</td>
											<?php }?>
											
										</tr>
									<?php }?>
								</tbody>
							</table>
						</div>
				</div>
			</div>
		</div>
	</div>
</div>


<!-- Page-Level Scripts -->
<script>
    $(document).ready(function () {
            $('.dataTables-example').DataTable({
                pageLength: 25,
                responsive: false,
                dom: '<"html5buttons"B>lTfgitp',
                buttons: [
                    {extend: 'copy'},
                    {extend: 'excel', title: ' Staffs'},
                    {extend: 'pdf', title: ' Staffs'},

                    {extend: 'print',
                        customize: function (win) {
                            $(win.document.body).addClass('white-bg');
                            $(win.document.body).css('font-size', '10px');

                            $(win.document.body).find('table')
                                    .addClass('compact')
                                    .css('font-size', 'inherit');
                        }
                    }
                ]

            });
    });
</script>
