<div class="wrapper wrapper-content animated fadeInRight">

    <form class="form">
        <div class="row">
			<div class="col-md-12">
				<div class="form-group col-md-4">
					<input type="text" class="form-control" name="q" value="<?= $this->input->get_post('q') ?>" placeholder="Search By Order Id,Mobile,Email,ZIP Code">
				</div>
				<div class="form-group col-md-2">
					<select class="form-control" name="s">
						<option value="">Select Status</option>
						<?php
							$status = array('Pending','Accepted','Cancelled','Completed');
							foreach($status as $sitem){
								$selected = '';
								if($sitem == $this->input->get_post('s')){
									$selected = 'selected="selected"';
								}
								echo '<option value="'.$sitem.'" '.$selected.'>'.$sitem.'</option>';
							}
						?>
					</select>
				</div>
				<div class="form-group col-md-2">
					<input type="text" class="form-control datepicker" name="fd" value="<?= $this->input->get_post('fd') ?>" placeholder="From Date">
				</div>
				<div class="form-group col-md-2">
					<input type="text" class="form-control datepicker" name="td" value="<?= $this->input->get_post('td') ?>" placeholder="To Date">
				</div>
				<div class="col-md-2">
					<button type="submit" class="btn btn-info">Search</button>
				</div>
			</div>
		</div>
    </form>
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5><?=$page_title?></h5>
                    </div>
                    <div class="ibox-content">
						<table class="table table-responsive table-bordered">
							<thead>
								<tr>
									<th>S.No</th>
									<th>Order Id </th>
									<th>Customer Name </th>
									<th>Date</th>
									<th>Service Status</th>			
									<th>Payment Status</th>			
									<th>Total Amount</th>			
									<th>Vendor Share</th>			
									<th>Franchise Share</th>			
									<th>Admin Share</th>			
									<th>Referral Share</th>			
									<th>Action</th>			
								</tr>
							</thead>
							<tbody>
								<?php $i=1; foreach($items as $item){ ?>
								<tr>
									<td><?=$i++?></td>
									<td><?=$item->booking_id?></td>
									<td><?=$item->customer_name?></td>
									<td class="text-center"><?= (isset($item->paid_at)) ? date('d-m-Y h:i a',$item->created_at) : '-'?></td>
									<?php
										if($item->service_status == 'Pending'){
											$bootstrap_class = 'warning';
										}elseif($item->service_status == 'Accepted'){
											$bootstrap_class = 'success';
										}elseif($item->service_status == 'Cancelled'){
											$bootstrap_class = 'danger';
										}elseif($item->service_status == 'Completed'){
											$bootstrap_class = 'primary';
										}elseif($item->service_status == 'Rejected'){
											$bootstrap_class = 'danger';
										}elseif($item->service_status == 'Process'){
											$bootstrap_class = 'success';
										}
									?>
									<td><span class="label label-<?=$bootstrap_class?>"><?=$item->service_status?></span></td>
									<?php
										if($item->payment_status == 'Pending'){
											$bootstrap_class = 'warning';
										}elseif($item->payment_status == 'Cancelled'){
											$bootstrap_class = 'danger';
										}elseif($item->payment_status == 'Paid'){
											$bootstrap_class = 'primary';
										}
									?>
									<td><span class="label label-<?=$bootstrap_class?>"><?=$item->payment_status?></span></td>
									<td><?=number_format($item->payable_amount,2)?></td>
									<td><?=number_format(($item->payable_amount - ($item->admin_share_amount + $item->franchise_share_amount + $item->referral_share_amount)),2)?></td>
									<td><?=number_format($item->franchise_share_amount,2)?></td>
									<td><?=number_format($item->admin_share_amount,2)?></td>
									<td><?=number_format($item->referral_share_amount,2)?></td>
									<td><a href="<?=base_url().'admin/'.$this->router->fetch_class().'/ecommerce_order_view/'.$item->id?>" class="btn btn-success btn-sm">View</a></td>
								</tr>
								<?php }?>
							</tbody>
						</table>
                    </div>
					<div class="ibox-footer text-center">
						<?=$pagination?>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>