<?php

class Site_model extends CI_Model {

    function is_username_exists($username) {
        $data = $this->db->get_where("users", ['username' => $username]);
        if ($data->num_rows() == 0) {
            return false;
        }
        $data = $data->row();
        return $data->id;
    }

    function get_site_properties() {
        return $this->db->get_where("site_settings", ["id" => 1])->row();
    }

    function get_home_page_sub_menu($id) {
        return $this->db->get_where("sub_categories", ["category_id" => $id, "status" => 1])->result();
    }

    function get_social_media_links() {
        return $this->db->get_where("socail_media")->row();
    }

    function check_user_status($user_id) {
        $data = $this->db->get_where("users", ['id' => $user_id])->row();
        if ($data) {
            if ($data->status == 0) {
                return false;
            } else {
                return true;
            }
        }
        return true;
    }

    function user_profile_update() {
        extract($_POST);
        $user_id = $this->get_logged_user_id();
        $data = array(
            "firstname" => $firstname,
            "lastname" => $lastname,
            "mobile" => $mobile,
            "email" => $email,
            "address" => addslashes($address),
            "updated_at" => time()
        );
        $this->db->set($data);
        $this->db->where("id", $user_id);
        return $this->db->update("users");
    }

    function get_user_role($user_id) {
        return $this->db->get_where("users", ['id' => $user_id])->row()->role_id;
    }

    function get_logged_user_id() {
        return $this->session->userdata("user_id");
    }

    function reset_password($user_id) {
        $password = rand(1, 9) * 11;
        $password .= rand(1, 9) * 11;
        $password .= rand(1, 9) * 11;
        $salt = rand(552555, 258242152);
        $smsPwd = $password;
        $password = md5($password . $salt);
        $this->db->set("password", $password);
        $this->db->set("salt", $salt);
        $this->db->where("id", $user_id);
        if ($this->db->update("users")) {

            $ud = $this->get_user_details($user_id);

            $mobile_number = $ud->mobile;
            $message = "Dear " . $ud->firstname . " " . $ud->lastname . ", Your New Password is - " . $smsPwd . ", Please Don\'t share with anyone";
            send_message($message, $mobile_number);
            return true;
        } else {
            return false;
        }
    }

    function user_profile_password_update($user_id) {
        extract($_REQUEST);
        $salt = rand(552555, 258242152);
        $smsPwd = $password;
        $password = md5($password . $salt);
        $this->db->set("password", $password);
        $this->db->set("salt", $salt);
        $this->db->where("id", $user_id);
        if ($this->db->update("users")) {

            $ud = $this->get_user_details($user_id);

            return true;
        } else {
            return false;
        }
    }

    function check_for_current_password_ok($user_id) {
        extract($_REQUEST);
        $ud = $this->get_user_details($user_id);
        if ($ud->password == md5($current_password . $ud->salt)) {
            return true;
        } else {
            return false;
        }
    }

	function get_user_details($user_id) {
        $user_details = $this->db->get_where("users", ['id' => $user_id])->row();
        return $user_details;
    }

    function login_validation($user_id, $password) {
        $data = $this->get_user_details($user_id);

        if ($data->password == md5($password . $data->salt)) {
            $this->do_logout();
            $ip = $_SERVER["REMOTE_ADDR"];

            $this->session->set_userdata("user_id", $user_id);
            $this->session->set_userdata("logged", true);

            $ch = curl_init();
            //curl_setopt($ch, CURLOPT_URL, "http://ip-api.com/json/$ip?fields=520191");
            curl_setopt($ch, CURLOPT_URL, "http://freegeoip.net/json/$ip");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $contents = curl_exec($ch);
            $response = json_decode($contents);
            curl_close($ch);
            if (isset($response->city) && isset($response->region_name) && isset($response->country_name)) {
                $address = "City : <b>$response->city</b> <br/>
								Region : <b>$response->region_name</b><br/>	
								Country : <b>$response->country_name</b><br/>	
										TimeZone : <b>$response->time_zone</b><br/>	
								";

                $insert_data = array("address" => $address,
                    "user_id" => $data->id, "created_at" => time());
                $this->db->insert("login_logs", $insert_data);
            }
            return true;
        } else {
            return false;
        }
    }

    function check_for_user_logged() {
        $user_id = $this->get_logged_user_id();
        if ($this->session->userdata("logged")) {
            if ($this->get_user_details($user_id)->status == 0) {
                $this->session->unset_userdata("user_id");
                $this->session->unset_userdata("logged");
                return false;
            }
            return true;
        } else {
            $this->session->unset_userdata("user_id");
            $this->session->unset_userdata("logged");
            $this->session->set_flashdata("timeout");
            return false;
        }
    }

    function do_logout() {
        $this->session->unset_userdata("user_id");
        $this->session->unset_userdata("logged");
        $this->session->set_flashdata("timeout");
        delete_cookie("token");
        unset($_COOKIE["token"]);
        unset($_COOKIE["last_login"]);
        return true;
    }

}
