<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Submit_withdraw_money_request extends MY_Controller {

    function __construct() {
        parent::__construct();
    }

    function index() {
        $token = $this->input->get_post("token");
        $user_id = $this->get_user_id($token);
        $amount = $this->input->get_post('amount');

        $wallet_amount = $this->wallet($user_id);
        if ($wallet_amount < $amount) {
            $arr = array('err_code' => "invalid", "title" => "alert", "message" => "Withdraw request has been rejected");
            echo json_encode($arr);
            die;
        }

        $request_id = $this->business_model->generate_withdraw_payment_db_ledger_request_id();

        $this->db->set("request_id", $request_id);
        $this->db->set("action_by", "Withdraw");
        $this->db->set("action_type", "Debit");
        $this->db->set("amount", $amount);
        $this->db->set("user_id", $user_id);
        $this->db->set("by_ref", "Customer");
        $this->db->set("request_status", "Pending");
        $this->db->set("created_at", time());
        $response = $this->db->insert("payments_ledger");
        if ($response) {
            $arr = array('err_code' => "valid", "title" => "success", "message" => "Withdraw request submitted successfully");
        } else {
            $arr = array('err_code' => "invalid", "title" => "alert", "message" => "Withdraw request has been rejected");
        }
        echo json_encode($arr);
    }

    function wallet($user_id) {
        $this->db->select("SUM(amount) as amount");
        $this->db->where("user_id", $user_id);
        $this->db->where("action_type", "Debit");
        $this->db->where("request_status", "Completed");
        $debit = $this->db->get("payments_ledger")->row()->amount;

        $this->db->select("SUM(amount) as amount");
        $this->db->where("user_id", $user_id);
        $this->db->where("action_type", "Credit");
        $this->db->where("request_status", "Completed");
        $credit = $this->db->get("payments_ledger")->row()->amount;

        return $credit - $debit;
    }

}
