<?php

//

header('Content-type: application/json');

class Submit_service_request extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('customer_model');
        $this->load->model('business_model');
        $this->is_token_required();
    }

    function index() {
        $token = $this->input->get_post("token");
        $user_id = $this->get_user_id($token);
        $customer_info = $this->user_model->get_user_details($user_id);

        //before placing order checking the customer has credit limit or not
        $customer_current_wallet_balance = $this->customer_model->get_wallet_balance($user_id);
        $customer_credit_limit = -$this->customer_model->get_credit_limit($user_id);

        /* echo "Customer current balance : " . $customer_current_wallet_balance;
          echo "Customer credit limit :" . $customer_credit_limit;

          var_dump($customer_credit_limit <= $customer_current_wallet_balance);
          die; */

        if ($customer_credit_limit >= $customer_current_wallet_balance) {

            $franchise_info = $this->user_model->get_user_details($customer_info->authorized_franchise_id);
            if ($franchise_info->status == 1) {
                $contact_number = $franchise_info->mobile;
            } else {
                $contact_number = $this->db->get("site_settings")->row()->contact_number;
            }
            $arr = array('err_code' => "invalid", "title" => "Insufficient Balance", "message" => "Your credit limit has been exceeded\n Please contact your admin\n Contact Number: $contact_number");
            echo json_encode($arr);
            die;
        }
        //before placing order checking the customer has credit limit or not END
        //before placing order checking any vendor is available or not
        $sub_category_id = $this->input->get_post('sub_category_id');
        if ($this->business_model->getting_available_vendors_for_pincode_and_selected_subcategory($customer_info->pincode, $sub_category_id) == false) {
            $arr = array('err_code' => "invalid",
                "subscription_err_code" => "",
                "title" => "Oops! Sorry",
                "message" => "This request cannot be fulfilled\n We are working on to get it",
                "extra_message" => "No vendors available in your pincode"
            );
            echo json_encode($arr);
            die;
        }
        //before placing order checking any vendor is available or not END
        //before placing order check for subscription 

        /* $subscription_response = $this->customer_model->check_subscription_plan_is_expired();
          if ($subscription_response == "SUBSCRITPION_IS_REQUIRED") {
          $arr = array('err_code' => "invalid",
          "subscription_err_code" => "SUBSCRITPION_IS_REQUIRED",
          "title" => "Oops! Sorry",
          "message" => "Please subscribe to place an order",
          "extra_message" => "Subscribtion is required to place order, so redirect customer to subscription plans page"
          );
          echo json_encode($arr);
          die;
          } else if ($subscription_response == "SUBSCRITPION_IS_EXPIRED") {
          $arr = array('err_code' => "invalid",
          "subscription_err_code" => "SUBSCRITPION_IS_EXPIRED",
          "title" => "Oops! Sorry",
          "message" => "Your subscription was expired please renew",
          "extra_message" => "Subscribtion is required to place order, so redirect customer to subscription plans page"
          );
          echo json_encode($arr);
          die;
          } else {

          } */


//before placing order checking for subscription end
        //Preparing data to place order
        $data = array(
            "user_id" => $user_id,
            "service_subject" => $this->input->get_post('service_subject'),
            "message" => $this->input->get_post('message'),
            "sub_category_id" => $sub_category_id,
            "source" => $this->input->get_post('source')
        );
        $response = $this->business_model->create_booking($data);
        //checking order has been created or not
        if ($response) {
            $arr = array('err_code' => "valid", "order_id" => $response, "title" => "Thank you", "message" => "We have received your request Ref Id: #" . $response);
        } else {
            $arr = array('err_code' => "invalid", "data" => $this->data["user"], "subscription_err_code" => "", "title" => "Oops! Try again", "message" => "Order Not created Please try again");
        }

        echo json_encode($arr);
    }

}
