<?php

header('Content-type: application/json');

class My_services extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        $token = $this->input->get_post("token");
        $user_id = $this->get_user_id($token);
        $filter = array();

        $filter = array(
            "q" => $this->input->get_post('q')
        );

        $total_results = $this->customer_model->get_my_services($filter, $user_id);

        $limit = $this->input->get_post("limit") ? $this->input->get_post("limit") : ORDERS_PER_PAGE;
        $_GET['page'] = $this->input->get_post("start");
        $start = $this->input->get_post("start") > 1 ? ($this->input->get_post("start") - 1) * $limit : 0;


        $pagination = my_pagination("search_result.php", $limit, $total_results, true);
        $pagination['pagination'] = str_replace("&amp;", "&", $pagination['pagination']);

        $data = $this->customer_model->get_my_services($filter, $user_id, $start, $limit);

        if ($data) {
            $arr = array('err_code' => "valid", "title" => "Service Orders", "message" => "Total Service Orders " . $total_results, "total_results" => $total_results, "pagination" => $pagination, "data" => $data);
        } else {
            $arr = array('err_code' => "invalid", "data" => [], "message" => "You have not yet placed any order");
        }

        echo json_encode($arr);
    }

    function view() {
        $token = $this->input->get_post("token");
        $user_id = $this->get_user_id($token);
        $service_request_bookings_id = $this->input->get_post('id');

        $data = $this->customer_model->get_my_service_info($service_request_bookings_id, $user_id);

        if ($data) {
            $arr = array('err_code' => "valid", "title" => "My Orders", "message" => "My Service or Product orders", "data" => $data);
        } else {
            $arr = array('err_code' => "invalid", "data" => [], "message" => "You have not yet placed any order");
        }

        echo json_encode($arr);
    }

    function update_status() {
        $token = $this->input->get_post("token");
        $user_id = $this->get_user_id($token);
        $service_request_bookings_id = $this->input->get_post('id');

        $data = array(
            "is_customer_accepted" => (bool) $this->input->get_post('is_customer_accepted', true)
        );

        $customer_current_wallet_balance = $this->customer_model->get_wallet_balance($user_id);
        $customer_credit_limit = $this->customer_model->get_credit_limit($user_id);
        $product_cost = $this->input->get_post("grand_total");

        if (($customer_current_wallet_balance + $customer_credit_limit) >= $product_cost) {
            $response = $this->customer_model->update_status($service_request_bookings_id, $user_id, $data);
            $data2 = $this->customer_model->get_my_service_info($service_request_bookings_id, $user_id);
            if ($response) {
                $arr = array('err_code' => "valid", "title" => "Updated Successfully", "message" => "Service status has been updated successfully", "data" => $data2);
            } else {
                $arr = array('err_code' => "invalid", "data" => [], "message" => "Sorry, Please try again");
            }
            echo json_encode($arr);
        } else {
            $difference_amount = $product_cost - ($customer_current_wallet_balance + $customer_credit_limit);
            $customer_info = $this->user_model->get_user_details($user_id);
            $franchise_info = $this->user_model->get_user_details($customer_info->authorized_franchise_id);
            if ($franchise_info->status == 1) {
                $contact_number = $franchise_info->mobile;
            } else {
                $contact_number = $this->db->get("site_settings")->row()->contact_number;
            }
            $arr = array('err_code' => "invalid", "title" => "Insufficient Balance", "message" => "Please add amount Rs." . $difference_amount . "/- more \n Please contact your admin\n Contact Number: $contact_number", "data" => $data2);
            echo json_encode($arr);
        }
    }

    function update_feedback() {
        $token = $this->input->get_post("token");
        $user_id = $this->get_user_id($token);
        $service_request_bookings_id = $this->input->get_post('id');

        $data = array(
            "customer_feedback" => $this->input->get_post('customer_feedback', true),
            "rating" => $this->input->get_post('rating', true),
        );

        $response = $this->customer_model->update_feedback($service_request_bookings_id, $user_id, $data);
        $data2 = $this->customer_model->get_my_service_info($service_request_bookings_id, $user_id);

        if ($response) {
            $arr = array('err_code' => "valid", "title" => "Updated Successfully", "message" => "Thanks for your feedback", "data" => $data2);
        } else {
            $arr = array('err_code' => "invalid", "data" => [], "message" => "Sorry, Please try again");
        }

        echo json_encode($arr);
    }

}
