<?php

header('Content-type: application/json');

class Verify_otp extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model("register_model");
        $this->load->model('login_model');
    }

    function index() {
        if (!$this->input->get_post('mobile')) {
            $arr = array('err_code' => "invalid", "error_type" => "mobile_required", "message" => "Mobile is required");
            echo json_encode($arr);
            die;
        }
        if (!$this->input->get_post('otp')) {
            $arr = array('err_code' => "invalid", "error_type" => "otp_required", "message" => "OTP is required");
            echo json_encode($arr);
            die;
        }
        if ($this->user_model->check_mobile_existance($this->input->get_post("mobile")) != TRUE) {
            $arr = array('err_code' => "invalid", "error_type" => "mobile_not_registered", "message" => "This mobile number is not registered with us");
            echo json_encode($arr);
            die;
        }

        $user_id = $this->db->get_where('users', ['mobile' => $this->input->get_post('mobile')])->row()->id;
        if ($this->user_model->verify_otp($user_id, $this->input->get_post('otp'))) {
            $user_token = $this->db->get_where("users", ["id" => $user_id])->row()->token;
            $data = $this->db->get_where("users", ["mobile" => $this->input->get_post('mobile')])->row();
            $arr = array(
                'err_code' => "valid",
                "message" => "OTP Verified successfully",
                "mobile" => $this->input->get_post("mobile"),
                "access_token" => $user_token,
                "user_id" => $user_id,
                "user" => $this->login_model->create_login_session($data)
            );
            $arr["user"]->id = $user_id;
        } else {
            $arr = array('err_code' => "invalid",
                "error_type" => "invalid_otp",
                "title" => "Invalid Verification Code",
                "message" => "Please enter a valid verification code",
                "mobile" => $this->input->get_post("mobile"),
            );
        }
        echo json_encode($arr);
    }

}
