<?php

header('Content-type: application/json');

class Update_profile extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        $staff_id = $this->input->get_post("staff_id");
        if (!$this->input->get_post('staff_id')) {
            $arr = array('err_code' => "invalid", "error_type" => "user_id_required", "message" => "Staff id is required");
            echo json_encode($arr);
            die;
        }
        if (!$this->input->get_post("name")) {
            $arr = array('err_code' => "invalid", "message" => "Name is required");
            echo json_encode($arr);
            die;
        }

        $data = array(
            "name" => $this->input->get_post('name', true),
            "email" => $this->input->get_post('email', true),
            "mobile" => $this->input->get_post('mobile', true),
			"image" => $this->upload_captured_image()
        );
		
        $this->db->set($data);
        $this->db->where("id", $staff_id);
        if ($this->db->update("staff")) {
            $this->data["staff"] =$this->user_model->get_staff_details($staff_id);
            $arr = array('err_code' => "valid", "data" => $this->data["user"], "message" => "Profile Updated Successfully");
            echo json_encode($arr);
        } else {
            $arr = array('err_code' => "invalid", "message" => "Profile Not Updated");
            echo json_encode($arr);
        }
    }

	function upload_captured_image() {
        // keyname is image
		$staff_id = $this->input->get_post("staff_id");
		$log_name = md5(microtime())."staff_id_".$staff_id.time().'.jpeg';
		$logo_image = FILE_UPLOAD_FOLDER.$log_name;
		if(file_put_contents($logo_image, base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $this->input->get_post('image'))))){
			return $log_name;
		}else{
			$arr = array('err_code' => "invalid", "message" => 'Unable to upload image', "data"=>[]);
		}
		echo json_encode($arr);
	}
}
