<?php

header('Content-type: application/json');

class Tips extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $user_id = $this->input->get_post('user_id');
        $user_status = $this->user_model->check_is_subscription_expired($user_id);
        if ($user_status == false) {
            $arr = array('err_code' => "invalid",
                "message" => "Sorry, Your subscription expired, Please renew it.",
                "user_id" => (int) $user_id
            );
            echo json_encode($arr);
            die;
        }
    }

    function index() {
        extract($_REQUEST);
        $limit = $this->input->get_post("limit") ? $this->input->get_post("limit") : 10;
        $start = $this->input->get_post("start") > 1 ? $this->input->get_post("start") : 0;

        $this->db->limit($limit, $start);

        $this->db->order_by("id", "desc");
        if ($this->input->get_post("from_date")) {
            $from_date = strtotime($this->input->get_post("from_date"));
            $this->db->where('created_at >=', $from_date);
        }
        if ($this->input->get_post("to_date")) {
            $to_date = strtotime($this->input->get_post("to_date"));
            $this->db->where('created_at <=', $to_date);
        }
        $this->db->where("status", 1);
        $data = $this->db->get("tips")->result();
        foreach ($data as $item) {
            //$item->time = time_elapsed_string($item->created_at);
            $item->time = date("d-m-Y h:i a", $item->created_at);
        }


        $this->db->where("status", 1);
        if ($this->input->get_post("from_date")) {
            $from_date = strtotime($this->input->get_post("from_date"));
            $this->db->where('created_at >=', $from_date);
        }
        if ($this->input->get_post("to_date")) {
            $to_date = strtotime($this->input->get_post("to_date"));
            $this->db->where('created_at <=', $to_date);
        }
        $total_results = $this->db->count_all_results("tips");

        $arr = array('err_code' => "valid", "message" => "All Tips", "total_results" => $total_results, "data" => $data);

        echo json_encode($arr);
    }

}
