<?php

header('Content-type: application/json');

class Send_otp extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model("register_model");
    }

    function index() {
        if (!$this->input->get_post('mobile')) {
            $arr = array('err_code' => "invalid", "error_type" => "mobile_required", "message" => "Mobile is required");
            echo json_encode($arr);
            die;
        }
        if ($this->user_model->check_mobile_existance($this->input->get_post("mobile")) != TRUE) {
            $arr = array('err_code' => "invalid", "error_type" => "mobile_not_registered", "message" => "Your entered mobile is not registered with us");
            echo json_encode($arr);
            die;
        }

        $user_id = $this->db->get_where('users', ['mobile' => $this->input->get_post('mobile')])->row()->id;
        $this->user_model->send_verfication_otp($user_id);
        $user_token = $this->db->get_where("users", ["id" => $user_id])->row()->token;
        $arr = array(
            'err_code' => "valid",
            "title" => "OTP send successfully",
            "message" => "Please check your mobile to complete verification",
            "mobile" => $this->input->get_post("mobile"),
            "access_token" => $user_token
        );
        echo json_encode($arr);
    }

}
