<?php
header('Content-type: application/json');
class Day_wise extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->input->get_post("staff_id")) {
            $arr = array('err_code' => "invalid", "error_type" => "staff_id_required", "message" => "Staff id is required");
            echo json_encode($arr);
            die;
        }
		
		if (!$this->input->get_post("for_date")) {
            $arr = array('err_code' => "invalid", "error_type" => "for_date_required", "message" => "For date is required");
            echo json_encode($arr);
            die;
        }
		
		$staff_id = $this->input->get_post("staff_id");
		$given_date = $this->input->get_post('for_date');
		
		$data = [];
		
		
		$this->db->select("date, date_time, actual_office_in_time, actual_office_out_time, lat, lng,location_name, captured_image, type, comment");
		$this->db->where("status", 1);
		$this->db->where("staff_id", $staff_id);
		$this->db->where("date", $given_date);
		$result = $this->db->get("staff_attendance")->result();

		if($result){
			$is_present = 1;
			$absent_message = "";
		}else{
			$is_present = 0;
			$absent_message =  "You are not present today you might be took leave";
		}
		
		$data = [
			"is_present"=>$is_present,
			"is_checked_in" => 0,
			"is_checked_out" => 0,
			"check_in_info" => array(),
			"check_out_info" => array(),
			"absent_message" => $absent_message 
		];
		
		foreach($result as $item){
			
			if($item->location_name == NULL){
				$item->location_name = $this->get_location_name($item->lat, $item->lng);
				if($item->location_name){
					$this->db->set("location_name", $item->location_name);
					$this->db->where("id", $item->id);
					$this->db->update("staff_attendance");
				}
			}
			
			$item->captured_image = FILE_UPLOAD_FOLDER_IMG_PATH.$item->captured_image;
			
			
			if($item->type == "In"){
				$data["is_checked_in"] = 1;
				unset($item->actual_office_out_time);
				unset($item->type);
				$data["check_in_info"] = $item;
			}else if($item->type == "Out"){
				$data["is_checked_out"] = 1;
				unset($item->actual_office_in_time);
				unset($item->type);
				$data["check_out_info"] = $item;
			}
		}
		
		if($data){
			$arr = array(
				'err_code' => "valid", 
				"message" => "Staff attendance for the selected date", 
				"staff_id"=>$staff_id,
				"for_date"=>$given_date,
				"data"=>$data
			);
		}else{
			$arr = array(
				'err_code' => "invalid", 
				"message" => "Staff attendance for the selected date", 
				"staff_id"=>$staff_id,
				"start_date"=>$given_date,
				"end_date"=>$end_date,
				"data"=>[]
			);
		}
		
		echo json_encode($arr);
	}
	
	
	function get_location_name($lat, $lng){
		$url = "https://maps.googleapis.com/maps/api/geocode/json?address=".$lat.",".$lng;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$arr = json_decode(curl_exec($ch));
		if(isset($arr->results[0]->formatted_address)){
			return $arr->results[0]->formatted_address; 
		}
		return null;
	}
}