<?php

class Staff_bulk_upload extends CI_Controller {

    private $data;

    function __construct() {
        parent::__construct();
		if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }
		$this->load->library("Spreadsheet_Excel_Reader");
        
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
		$this->admin_view("staff_bulk_upload");
    }
	
	function preview(){
		if($_SERVER['REQUEST_METHOD']=="POST"){
			$file = $_FILES["uploadexcle"]['tmp_name'];
			$data = new Spreadsheet_Excel_Reader($file);
			$cells = $data->sheets[0]["cells"];
			$this->data['cells'] = $cells;
			$this->admin_view("staff_uploaded_excel_preview");
		}else{
			redirect("admin/staff_bulk_upload");
		}
	}
	
	function save(){
		if($_SERVER['REQUEST_METHOD']=="POST"){
			$staff_array = json_decode($_POST['staff_array']);
			
			foreach($staff_array as $item){
				
				$employee_id = $item->{1};
				$name = $item->{2};
				$department_id = $this->get_department_id($item->{3});
				$designation_id = $this->get_designation_id($item->{4});
				$store_id = $this->get_store_id($item->{5});
				$region_id = $this->get_region_id($item->{6});
				$email = $item->{7};
				$mobile = $item->{8};
				$in_time = $item->{9};
				$out_time = $item->{10};
				$aadhar_number = isset($item->{11}) ? $item->{11}:null;
				$gender = isset($item->{12}) ? $item->{12}:null;
				
				
				$this->db->where("employee_id", $employee_id);
				if($this->db->get("staff")->num_rows()){
					continue;
				}
				
				
				$salt = rand(552555,258242152);
				$password = rand(1,9)*11;
				$password .= rand(1,9)*11;
				$password .= rand(1,9)*11;
				
				$smsPwd = $password;
				$password = md5($password.$salt);
				
				
				$this->db->set("department_id", $department_id);
				$this->db->set("region_id", $region_id);
				$this->db->set("designation_id", $designation_id);
				$this->db->set("store_id", $store_id);
				$this->db->set("name", $name);
				$this->db->set("employee_id", $employee_id);
				$this->db->set("mobile", $mobile);
				$this->db->set("email", $email);
				$this->db->set("aadhar_number", $aadhar_number);
				$this->db->set("aadhar_number", $gender);
				$this->db->set("in_time", $in_time);
				$this->db->set("out_time", $out_time);
				$this->db->set("created_at", time());
				$this->db->set("password", $password);
				$this->db->set("salt", $salt);
				if($this->db->insert("staff")){
					$message = "Dear ".$name.", your login has been created \nEmployee ID:".$employee_id."\nPassword: ".$smsPwd."\nDownload app http://goo.gl/vhjZUn";
						send_message($message, $mobile);
				}
			}
			
			echo "<script>
				alert('Uploaded successfully');
				location.href = location.href;
			</script>";
		}else{
			redirect("admin/staff_bulk_upload");
		}
	}
	
	function get_department_id($str){
		$this->db->where("name", $str);
		$row = $this->db->get("departments")->row();
		if($row){
			return $row->id;
		}else{
			$this->db->set("name", $str);
			$this->db->set("created_at", time());
			$this->db->set("status", 1);
			$this->db->insert("departments");
			return $this->db->insert_id();
		}
	}
	
	function get_region_id($str){
		$this->db->where("name", $str);
		$row = $this->db->get("regions")->row();
		if($row){
			return $row->id;
		}else{
			$this->db->set("name", $str);
			$this->db->set("created_at", time());
			$this->db->set("status", 1);
			$this->db->insert("regions");
			return $this->db->insert_id();
		}
	}
	
	function get_designation_id($str){
		$this->db->where("name", $str);
		$row = $this->db->get("designations")->row();
		if($row){
			return $row->id;
		}else{
			$this->db->set("name", $str);
			$this->db->set("created_at", time());
			$this->db->set("status", 1);
			$this->db->insert("designations");
			return $this->db->insert_id();
		}
	}

	function get_store_id($str){
		$this->db->where("store_name", $str);
		$row = $this->db->get("stores")->row();
		if($row){
			return $row->id;
		}else{
			$this->db->set("store_name", $str);
			$this->db->set("created_at", time());
			$this->db->set("status", 1);
			$this->db->insert("stores");
			return $this->db->insert_id();
		}
	}
}