<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Paypal_operations extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->helper("paypal_functions");
        $this->load->library("paypal");
    }

    function transactions() {
        $ps = $this->db->get_where("admin_paypal_settings")->row();
        $paypal = new Paypal();
        $paypal->PPL_API_USER = $ps->ppl_username;
        $paypal->PPL_API_PASSWORD = $ps->ppl_password;
        $paypal->PPL_API_SIGNATURE = $ps->ppl_signature;
        $paypal->PPL_MODE = PAYPAL_MODE;

        $padata = "";

        if ($this->input->get_post("start_date")) {
            $date = date_create_from_format('m-d-Y', $this->input->get_post("start_date"));
            $sdate = date_format($date, 'Y-m-d');
        } else {
            $sdate = date("Y-m-d", strtotime("-1 day"));
        }
        $sdate .= "T12:00:00Z";
        $padata .= '&STARTDATE=' . urlencode($sdate);

        if ($this->input->get_post("to_date")) {
            $date = date_create_from_format('m-d-Y', $this->input->get_post("to_date"));
            $edate = date_format($date, 'Y-m-d');
        } else {
            $edate = date("Y-m-d");
        }
        $edate .= "T12:00:00Z";
        $padata .= '&ENDDATE=' . urlencode($edate);


        if ($this->input->get_post("type")) {
            $padata .= '&TRANSACTIONCLASS=' . urlencode($this->input->get_post("type"));
        }

        if ($this->input->get_post('by_txn') == "true") {
            $padata = '&TRANSACTIONID=' . urlencode($this->input->get_post("transaction_id"));
        }

        $this->data['transactions'] = $paypal->GetTransactions($padata);

        // print_r($this->data['transactions']);

        $total_size_of_array = count($this->data['transactions']);
        $required_transaction_size_of_array = (($total_size_of_array - 5) - 1) / 10;

        $array = [];
        foreach ($this->data['transactions'] as $key => $item) {
            $v = explode("=", $item);
            $array[$v[0]] = $v[1];
        }

        $data_grid = array();

        for ($i = 0; $i < $required_transaction_size_of_array; $i++) {

            $data_grid[$i][] = $array["L_TIMESTAMP$i"];
            $data_grid[$i][] = $array["L_TIMEZONE$i"];
            $data_grid[$i][] = $array["L_TYPE$i"];
            $data_grid[$i][] = $array["L_NAME$i"];
            $data_grid[$i][] = $array["L_TRANSACTIONID$i"];
            $data_grid[$i][] = $array["L_STATUS$i"];
            $data_grid[$i][] = $array["L_AMT$i"];
            $data_grid[$i][] = $array["L_CURRENCYCODE$i"];
            $data_grid[$i][] = $array["L_FEEAMT$i"];
            $data_grid[$i][] = $array["L_NETAMT$i"];
        }
        $this->data["data_grid"] = $data_grid;

        $this->admin_view("paypal_transactions");
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
        $this->admin_view("paypal_transactions");
    }

}
