<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Month_wise extends MY_Controller {

	public function __construct() {
        parent::__construct();
        if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }
		
		if(!$this->input->get_post('month') && !$this->input->get_post('year')){
			redirect("admin/month_wise?month=".date("F")."&year=".date("Y"));
		}
		
		for ($i = 0; $i < 12; $i++) {
			$timestamp = mktime(0, 0, 0, date('n') - $i, 1);
			$this->data['months'][date('n', $timestamp)] = date('F', $timestamp);
		}
		ksort($this->data['months']);
		
		for($i=2018; $i<=date("Y"); $i++){
			$this->data["years"][] = $i;
		}
		
		$this->data["regions"] = $this->admin_model->get_all_regions();
		
		$this->data["stores"] = $this->admin_model->get_active_stores_data();
		if($this->input->get_post('store_id')){
			$this->db->where("store_id", $this->input->get_post('store_id'));
		}
		if($this->input->get_post('region_id')){
			$this->db->where("region_id", $this->input->get_post('region_id'));
		}
		
		//$this->db->limit(4);
		$this->data["staff"] = $this->admin_model->get_active_staff_data();
		
		if($this->input->get_post('month') && $this->input->get_post('year')){
			$m = $this->input->get_post("month");
			$y = $this->input->get_post("year");
			
			$given_date = date_create_from_format("Y-M-d", $y."-".$m."-01");
			$start_value = date_format($given_date, 'd-D');
			
			$given_month_index = date_format($given_date, 'm');
			$number_of_days = cal_days_in_month(CAL_GREGORIAN, $given_month_index, $y); 
			
			$start = date_format($given_date, 'd');
			$end = $number_of_days;
			
			
			$start_date = date_format($given_date, 'Y-m-d');
			$end_date = date("Y-m")."-".$number_of_days;
			
			$this->data["headding_columns"] = [];
			
			//echo "Start ". $start;
			//echo "End ". $end;
			//die;
			
			for($i=$start; $i<=$end; $i++){
				$hd = date_format(date_create_from_format("Y-M-d", $y."-".$m."-".$i), 'd-D');
				$selected_date = date_format(date_create_from_format("Y-M-d", $y."-".$m."-".$i), 'Y-m-d');
				$this->data["headding_columns"][] = $hd;
				if(date("Y") == $y && $m == date("F") && $i==date("d")){
					$skip = true;
					break;
				}
			}
			
			foreach($this->data["staff"] as $staff_item){
				
				//print_r($staff_item);
				$staff_item->number_of_days_present = $this->staff_model->get_total_number_of_days_attend($staff_item->id, $start_date, $end_date);
				
				
				for($i=$start; $i<=$end; $i++){
					
					//selected month matchs the current month and year matches with to the current year then display only to today date only
					
					$hd = date_format(date_create_from_format("Y-M-d", $y."-".$m."-".$i), 'd-D');
					$selected_date = date_format(date_create_from_format("Y-M-d", $y."-".$m."-".$i), 'Y-m-d');
					
					
					$s_item =  $this->staff_model->get_staff_attendence_report_for_date($staff_item, $selected_date);
					
					if($s_item){
						$staff_item->$hd->check_in = isset($s_item->check_in) ? $s_item->check_in :"--";
						$staff_item->$hd->check_out = isset($s_item->check_out) ? $s_item->check_out :"--";;
					}else{
						$staff_item->$hd->check_in = "--";
						$staff_item->$hd->check_out = "--";
					}
					
					unset($s_item->check_in);
					unset($s_item->check_out);
					
					if(date("Y") == $y && $m == date("F") && $i==date("d")){
						$skip = true;
						break;
					}
					
				}
				/*if(isset($skip)){
					break;
				}*/
			}
			//print_r($this->data["staff"]);
			//die;
		}
		
    }
	
	function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }
	
	function index(){
		$this->admin_view("month_wise");
	}
}