<?php

class Dashboard extends CI_Controller {

    private $data;

    function __construct() {
        parent::__construct();
        if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
        $this->data['total_ventures'] = $this->admin_model->get_total_ventures();
        $this->data['total_active_ventures'] = $this->admin_model->get_active_ventures_cnt();
        $this->data['total_inactive_ventures'] = $this->admin_model->get_inactive_ventures();
		
		$this->data['total_plots'] = $this->admin_model->get_total_plots();
        $this->data['total_available_plots'] = $this->admin_model->get_total_available_plots();
        $this->data['total_booked_plots'] = $this->admin_model->get_total_booked_plots();
        $this->data['total_pending_plots'] = $this->admin_model->get_total_pending_plots();
		
        $this->data['total_staff'] = $this->admin_model->get_total_staff();
		$this->data['total_active_staff'] = $this->admin_model->get_active_staff();
        $this->data['total_inactive_staff'] = $this->admin_model->get_inactive_staff();
		
		$this->data['total_check_in_staff'] = $this->admin_model->get_check_in_staff();
		$this->data['total_non_check_in_staff'] = $this->admin_model->get_non_check_in_staff();
        $this->data['total_check_out_staff'] = $this->admin_model->get_total_check_out_staff();
        $this->data['total_non_check_out_staff'] = $this->admin_model->get_total_non_check_out_staff();
		
		$this->data["total_departments"] = $this->admin_model->get_total_departments();
		$this->data["total_regions"] = $this->admin_model->get_total_regions();
		
		
        $this->data['sms_credits'] = file_get_contents("http://login.smsmoon.com/API/get_balance.php?username=colourmoonalerts&password=vizag@123");
        $this->admin_view("dashboard");
    }
	
	function get_business_timings(){
		$this->db->select("opening_time, closing_time");
		return $this->db->get("business_timings")->row();
	}

}
