/*

Flot plugin for automatically redrawing plots when the placeholder

size changes, e.g. on window resizes.



It works by listening for changes on the placeholder div (through the

jQuery resize event plugin) - if the size changes, it will redraw the

plot.



There are no options. If you need to disable the plugin for some

plots, you can just fix the size of their placeholders.

*/





/* Inline dependency: 

 * jQuery resize event - v1.1 - 3/14/2010

 * http://benalman.com/projects/jquery-resize-plugin/

 * 

 * Copyright (c) 2010 "Cowboy" Ben Alman

 * Dual licensed under the MIT and GPL licenses.

 * http://benalman.com/about/license/

 */

(function($,h,c){var a=$([]),e=$.resize=$.extend($.resize,{}),i,k="setTimeout",j="resize",d=j+"-special-event",b="delay",f="throttleWindow";e[b]=250;e[f]=true;$.event.special[j]={setup:function(){if(!e[f]&&this[k]){return false}var l=$(this);a=a.add(l);$.data(this,d,{w:l.width(),h:l.height()});if(a.length===1){g()}},teardown:function(){if(!e[f]&&this[k]){return false}var l=$(this);a=a.not(l);l.removeData(d);if(!a.length){clearTimeout(i)}},add:function(l){if(!e[f]&&this[k]){return false}var n;function m(s,o,p){var q=$(this),r=$.data(this,d);r.w=o!==c?o:q.width();r.h=p!==c?p:q.height();n.apply(this,arguments)}if($.isFunction(l)){n=l;return m}else{n=l.handler;l.handler=m}}};function g(){i=h[k](function(){a.each(function(){var n=$(this),m=n.width(),l=n.height(),o=$.data(this,d);if(m!==o.w||l!==o.h){n.trigger(j,[o.w=m,o.h=l])}});g()},e[b])}})(jQuery,this);





(function ($) {

    var redrawing = 0;

    var options = { }; // no options



    function init(plot) {

        function bindEvents(plot, eventHolder) {

            if (!redrawing)

                plot.getPlaceholder().resize(onResize);



            function onResize() {

                var placeholder = plot.getPlaceholder();



                // somebody might have hidden us and we can't plot

                // when we don't have the dimensions

                if (placeholder.width() == 0 || placeholder.height() == 0)

                    return;

                

                ++redrawing;

                $.plot(placeholder, plot.getData(), plot.getOptions());

                --redrawing;

            }

        }

        

        plot.hooks.bindEvents.push(bindEvents);

    }

    

    $.plot.plugins.push({

        init: init,

        options: options,

        name: 'resize',

        version: '1.0'

    });

})(jQuery);